#pragma once

#include <string>
#include <common/context.h>

#include <processor_ng/processor_service.h>

namespace yrpopper { namespace processor {

class ProcessorHeaderGenerator
{
    enum MixedFlags
    {
        FLAG_DELETED = 128,
        FLAG_ANSWERED = 1024,
        FLAG_SEEN = 2048
    };

public:
    ProcessorHeaderGenerator(
        MessagePtr message,
        std::string crlf,
        rpop_context_ptr context,
        std::ostream& stream)
        : message(message), stream(stream), crlf(crlf), context(context)
    {
    }

    void generateBaseHeaders();
    void generateXYandexHint(MessageInfoPtr messageInfo);

private:
    MessagePtr message;
    std::ostream& stream;
    std::string crlf;

    rpop_context_ptr context;
};

} /* namespace processor */ } /* namespace yrpopper */
