#pragma once

#include <set>
#include <string>
#include <memory>

#include <boost/range/iterator_range.hpp>

namespace yrpopper { namespace processor {

struct MessageInfo
{
    time_t dateHeader = 0;
    time_t minReceivedDate = 0;
    time_t maxReceivedDate = 0;

    bool isLoop = false;
    bool hasReceived = false;
    bool isRecovery = false;
    std::string messageID;
};

typedef std::shared_ptr<MessageInfo> MessageInfoPtr;

class ProcessorHeaderHandler
{
    typedef boost::iterator_range<std::string::const_iterator> Range;

public:
    ProcessorHeaderHandler(
        std::set<std::string>& removeHeaders,
        std::string suid,
        std::ostream& stream)
        : stream(stream)
        , removeHeaders(removeHeaders)
        , suid(suid)
        , parsed(false)
        , messageInfo(std::make_shared<MessageInfo>())
    {
    }

    bool beginHeader(const std::string::const_iterator& it);
    bool endHeader(const std::string::const_iterator& it);
    bool headerField(const Range& line, const Range& eol);

    bool isParsed()
    {
        return parsed;
    }
    MessageInfoPtr getMessageInfo();
    std::string::const_iterator getHeadersEnd();

private:
    time_t parseDate(std::string date);
    time_t parseReceived(std::string received);
    bool parseForward(std::string forward);

private:
    std::ostream& stream;
    std::set<std::string>& removeHeaders;
    std::string suid;
    bool parsed;
    std::string::const_iterator lastHeaderEnd;
    MessageInfoPtr messageInfo;
};

typedef std::shared_ptr<ProcessorHeaderHandler> ProcessorHeaderHandlerPtr;

} /* namespace processor */ } /* namespace yrpopper */
