#pragma once

#include <processor_ng/processor_header_handler.h>
#include <processor_ng/processor_settings.h>
#include <processor_ng/smtpgate_poster.h>
#include <smtp/module.h>

#include <yplatform/active/object.h>
#include <common/context.h>
#include <common/config.h>

#include <ymod_smtpclient/call.h>

namespace yrpopper { namespace processor {

struct Message
{
    string_ptr body;
    string::const_iterator start;
    string::const_iterator end;

    bool dotStuffed = false;
    std::string imapId;
    std::string srcFolder;
    std::string dstFolder;
    std::string spamFolder;
    char dstDelim;

    std::vector<string> labels;
    std::vector<string> lids;

    bool deleted = false;
    bool answered = false;
    bool seen = false;
    bool flagged = false;
};
typedef std::shared_ptr<Message> MessagePtr;

class ProcessorError : public std::runtime_error
{
public:
    ProcessorError(std::string msg) : runtime_error(msg)
    {
    }
};

struct ProcessorResult
{
    std::string messageId;
    std::string smtpResponse;
};

class ProcessorService : public yplatform::active::object
{
public:
    ProcessorService(yplatform::reactor& reactor)
        : yplatform::active::object()
        , ioService(*reactor.io())
        , settings(std::make_shared<ProcessorSettings>())
    {
        L_(debug) << "processor::ProcessorService instaniated";
    }

    virtual ~ProcessorService()
    {
        L_(debug) << "processor::ProcessorService destroyed";
    }

    void init(const yplatform::ptree& xml);

    Future<ProcessorResult> processMessage(rpop_context_ptr context, MessagePtr message);

private:
    void doProcessMessage(
        rpop_context_ptr context,
        MessagePtr message,
        Promise<ProcessorResult> res);
    string getMessageCRLF(MessagePtr message);

    ProcessorHeaderHandlerPtr processMessageHeaders(
        rpop_context_ptr context,
        MessagePtr message,
        std::ostream& stream);
    void processMessageBody(
        MessagePtr message,
        string::const_iterator headersEnd,
        std::ostream& stream);

    void sendMessageSmtp(
        rpop_context_ptr context,
        const yplatform::zerocopy::segment& message,
        MessageInfoPtr messageInfo,
        Promise<ProcessorResult> res);
    void handleSmtpResult(
        rpop_context_ptr context,
        MessageInfoPtr messageInfo,
        Promise<ProcessorResult> res,
        Future<smtp::SMTPResult> smtpRes);

    boost::asio::io_service& ioService;
    ProcessorSettingsPtr settings;
};

} /* namespace processor */ } /* namespace yrpopper */
