#pragma once

#include <common/host_info.h>
#include <yplatform/ptree.h>

#include <set>
#include <string>
#include <memory>

namespace yrpopper { namespace processor {

struct ProcessorSettings
{
    void update(const yplatform::ptree& xml)
    {
        maxLetterSize = xml.get("max_letter_size", 41 * 1024 * 1024);

        smtpgateHost = xml.get("smtpgate_host", "https://smtpgate.mail.yandex.net/");
        smtpgateRetries = xml.get("smtpgate_retries", 3);
        smtpgatePercent = xml.get("smtpgate_percent", 0);

        auto headers = xml.get_child("remove_headers");
        for (auto& header : headers)
        {
            if (header.first == "<xmlattr>") continue;
            if (header.first == "header")
            {
                removeHeaders.insert(header.second.get_value<std::string>());
            }
            else
            {
                throw std::runtime_error(
                    "Wrong config format, not <header> in <remove_headers>, found: " +
                    header.first);
            }
        }

        myHostname = get_my_hostname();
    }

    uint32_t maxLetterSize = 41 * 1024 * 1024;

    std::string smtpgateHost;
    uint32_t smtpgateRetries = 3;
    uint32_t smtpgatePercent = 0;

    std::set<std::string> removeHeaders;

    std::string myHostname;
};

typedef std::shared_ptr<ProcessorSettings> ProcessorSettingsPtr;

} // namespace processor
} // namespace yrpopper
