#pragma once

#include <api/error.h>
#include <stdexcept>

namespace yrpopper::scheduler {

struct task_not_exists_error : public api::storage_error
{
    task_not_exists_error() : api::storage_error()
    {
    }
};

struct task_load_error : public api::internal_error
{
    task_load_error() : api::internal_error()
    {
    }
};

struct frequent_run_error : public api::internal_error
{
    frequent_run_error() : api::internal_error()
    {
    }
};

struct first_run_interval_error : public api::internal_error
{
    first_run_interval_error() : api::internal_error()
    {
    }
};

struct task_limits_reached_error : public api::internal_error
{
    task_limits_reached_error() : api::internal_error()
    {
    }
};

struct host_limits_reached_error : public api::internal_error
{
    host_limits_reached_error() : api::internal_error()
    {
    }
};

}
