#pragma once

#include <boost/thread.hpp>
#include <boost/property_tree/ptree.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/unordered_map.hpp>
#include <boost/unordered_set.hpp>

#include <yplatform/repository.h>
#include <yplatform/find.h>
#include <yplatform/log.h>

#include <ymod_pq/call.h>
#include <ymod_blackbox/auth.h>
#include <scheduler/scheduler.h>
#include <scheduler/dispatcher.h>
#include <common/context.h>
#include <common/util.h>

#include <map>

namespace yrpopper { namespace scheduler {

class scheduler_pq_impl : public SchedulerService
{
public:
    scheduler_pq_impl();
    virtual ~scheduler_pq_impl();

    void init(const yplatform::ptree& xml);
    void start();
    void reload(const yplatform::ptree& xml);
    void stop();
    void fini(void);

protected:
    // push task to processor
    void load_limits(const yplatform::ptree& xml);

    virtual const yplatform::module_stats_ptr get_module_stats() const
    {
        return boost::static_pointer_cast<yplatform::module_stats>(settings_->stat);
    }

    std::shared_ptr<const scheduler_pq_impl> get_shared_from_this() const
    {
        return std::static_pointer_cast<const scheduler_pq_impl>(shared_from_this());
    }

    std::shared_ptr<scheduler_pq_impl> get_shared_from_this()
    {
        return std::static_pointer_cast<scheduler_pq_impl>(shared_from_this());
    }

    future_void_t forceTaskRun(
        const yplatform::task_context_ptr& context,
        const popid_t& id,
        TaskRunParamsPtr params);

private:
    typedef boost::recursive_mutex mutex_t;
    typedef boost::unique_lock<mutex_t> lock_t;

    settings_ptr settings_;
    std::unique_ptr<dispatcher<database>> disp_;
    mutex_t mux_;
};

} // namespace scheduler
} // namespace yrpopper
