#pragma once

#include <common/config.h>
#include <scheduler/settings.h>
#include <scheduler/task_index.h>

namespace yrpopper { namespace scheduler {

class limit_controller
{
    typedef boost::mutex mutex_t;
    typedef boost::unique_lock<mutex_t> lock_t;
    typedef std::unordered_map<string, uint64_t> active_map;

public:
    limit_controller() : active_count_(0)
    {
    }

    void set_settings(const settings_ptr& settings)
    {
        lock_t lock(mux_);
        settings_ = settings;
    }

    start_result run_task(const string& host);
    void finish_task(const string& host);
    std::time_t get_task_penalty(const string& host) const;

private:
    host_limits_t get_limit(const string& host) const;
    const string& real_host(const string& host) const;

    mutable mutex_t mux_;
    settings_ptr settings_;
    active_map current_active_;
    std::size_t active_count_;
};

}}
