#pragma once

#include <boost/thread.hpp>
#include <boost/date_time.hpp>
#include <boost/asio.hpp>
#include <scheduler/settings.h>
#include <scheduler/task_index.h>

#include <list>
#include <stdint.h>
#include <sys/time.h>
#include <functional>
#include <unordered_map>

namespace yrpopper { namespace scheduler {

class plan_queue
{
    typedef boost::mutex mutex_t;
    typedef boost::unique_lock<mutex_t> lock_t;
    typedef std::unordered_map<popid_t, task_index> task_map;
    typedef std::deque<popid_t> task_queue;

public:
    typedef std::function<start_result(task_index ti)> run_handler;

    void init(const run_handler& h, const settings_ptr& st);

    void push(const task_index& ti);
    void pop(const popid_t& id);
    void on_task_finished(const popid_t& id);
    void start();
    void stop();
    std::optional<task_index> find(const popid_t id) const;
    void run_once();

    size_t pending_tasks_count() const
    {
        lock_t lock(mux_);
        return pending_tasks_.size();
    }

    size_t total_tasks_count() const
    {
        lock_t lock(mux_);
        return map_.size();
    }

private:
    void start_timer();
    void handle_timer(const boost::system::error_code& ec);

    mutable mutex_t mux_;
    std::shared_ptr<yplatform::time_traits::timer> timer_;
    run_handler handler_;
    yplatform::time_traits::duration queue_process_interval_ = yplatform::time_traits::seconds(1);
    task_map map_;
    task_queue pending_tasks_;
    settings_ptr settings_;
};

}}
