#pragma once

#include <common/config.h>
#include <common/data_source.h>

#include <yplatform/module.h>
#include <yplatform/task_context.h>

namespace yrpopper { namespace scheduler {

class TaskRunParams
{
public:
    enum class RunFlag
    {
        Verbose,
        Clean,
        ProcessorNG,
        Syncronized,

        ProxyXML,
        ProxyJSON
    };

    TaskRunParams()
    {
    }

    template <typename FlagsList>
    TaskRunParams(const FlagsList& flags) : flags(flags)
    {
    }

    bool hasFlag(RunFlag flag)
    {
        return flags.count(flag) > 0;
    }

private:
    std::set<RunFlag> flags;
};
typedef std::shared_ptr<TaskRunParams> TaskRunParamsPtr;

class SchedulerService : public yplatform::module
{
public:
    virtual ~SchedulerService(){};

    virtual future_void_t forceTaskRun(
        const yplatform::task_context_ptr& context,
        const popid_t& id,
        TaskRunParamsPtr params) = 0;
};

} // namespace scheduler
} // namespace yrpopper
