#pragma once

#include <common/util.h>
#include <common/config.h>
#include <common/context.h>
#include <common/host_info.h>
#include <boost/date_time.hpp>
#include <yplatform/active/pool.h>
#include <yplatform/time_traits.h>
#include <scheduler/stat.h>
#include <boost/regex.hpp>
#include <optional>
#include <unordered_map>

namespace yrpopper { namespace scheduler {

typedef std::unordered_map<string, unsigned> server_connections_t;

struct host_limits_t
{
    uint64_t max_active_tasks;
    std::time_t min_penalty;
};
typedef std::map<string, host_limits_t> host_limit_map;
typedef std::map<string, string> host_alias_map;

struct settings
{
    settings(const string& owner_name=get_my_hostname())
        : retries_limit(5)
        , fatal_retries_limit(35)
        , penalty(900)
        , force_penalty(20)
        , first_run_interval(300)
        , finished_penalty_multiplier(1.0)
        , enqueue_timeout(boost::posix_time::pos_infin)
        , queue_process_interval(yplatform::time_traits::seconds(1))
        , scheduler_pq_ctx(new sched_context)
        , stat(new module_stat)
        , max_tasks(1000)
        , default_limit(300)
        , my_owner_name(owner_name)
        , log_extra(false)
        , create_date_unread(946674000)
        , list_request_timeout(yplatform::time_traits::seconds(60))
    {
    }

    boost::posix_time::time_duration scan_interval;
    boost::posix_time::time_duration task_update_interval;
    unsigned retries_limit;
    unsigned fatal_retries_limit;
    std::time_t penalty;
    std::time_t force_penalty;
    std::time_t first_run_interval;
    float finished_penalty_multiplier;
    yplatform::active::time_duration enqueue_timeout;

    yplatform::time_traits::duration queue_process_interval;

    sched_context_ptr scheduler_pq_ctx;
    boost::shared_ptr<yplatform::active::pool> pool;
    boost::shared_ptr<module_stat> stat;

    uint64_t max_tasks;
    uint64_t default_limit;
    host_limit_map host_limits;
    host_alias_map aliases;

    string my_owner_name;
    string run_prefix;

    bool log_extra;

    std::time_t create_date_unread;
    versioned_keys_t dkeys;

    yplatform::time_traits::duration list_request_timeout;

    struct
    {
        bool enabled = false;
        boost::optional<std::size_t> tasks_sample_limit;

    } not_released_tasks_logging;
};

typedef boost::shared_ptr<settings> settings_ptr;

}}
