#pragma once

#include <common/config.h>
#include <common/context.h>

#include <yplatform/module.h>
#include <yplatform/zerocopy/segment.h>

namespace yrpopper::smtp {

struct SMTPResult
{
    std::string response;
};

struct SMTPException : std::runtime_error
{
    SMTPException(const std::string& message, const std::string& smtpResponse)
        : std::runtime_error(message), smtpResponse(smtpResponse)
    {
    }

    std::string smtpResponse;
};

class module : public yplatform::module
{
public:
    module(const yplatform::ptree& conf);

    Future<SMTPResult> sendMessage(
        rpop_context_ptr ctx,
        const std::string& email,
        const yplatform::zerocopy::segment& message);

    void logger(const yplatform::log::source& logger); // shadows base class method

private:
    class impl;
    std::shared_ptr<impl> impl_;
};

}
