LIBRARY()
OWNER(g:xeno)

NO_UTIL()
NO_WERROR()

CFLAGS(
    -DBOOST_SPIRIT_THREADSAFE
)

PEERDIR(
    contrib/libs/libidn
    contrib/libs/yajl

    mail/blowfish
    mail/butil
    mail/libyadns
    mail/mimeparser
    mail/ymod_blackbox
    mail/ymod_cache
    mail/ymod_httpclient
    mail/ymod_imapclient
    mail/ymod_popclient
    mail/ymod_pq
    mail/ymod_smtpclient
    mail/ymod_statserver
    mail/ymod_tvm
    mail/ymod_metricserver
    mail/ymod_webserver
    mail/yplatform/lib/convert
    mail/yplatform/lib

    mail/collectors-ext/src/api/rc/proto
)

ADDINCL(
    contrib/libs/c-ares/include
    contrib/libs/libidn
    mail/collectors-ext/src
)

SRCS(
    GLOBAL api/api_impl.cc
    api/impl/api_check.cc
    api/impl/api_create.cc
    api/impl/api_edit.cc
    api/impl/api_enable.cc
    api/impl/api_list.cc
    api/impl/api_remove.cc
    api/impl/util_duplicate.cc
    api/rc/basic_rc_client.cc
    api/rc/rc.cc
    api/util_blackbox.cc

    common/task_error.cc

    collector_ng/collector.cc
    GLOBAL collector_ng/collector_service.cc
    collector_ng/imap/collector_session_imap.cc
    collector_ng/imap/imap_folders_impl.cc
    collector_ng/http/collector_session_ms365_http.cc
    collector_ng/http/ms365_client.cc

    db/api_interface.cc
    db/handlers/rpop_list.cc
    db/handlers/task_info_handler.cc
    db/http_collector_interface.cc
    db/imap_collector_interface.cc
    db/legacy_interface.cc
    db/pop3_collector_interface.cc
    db/query/query.cc
    GLOBAL db/query_dispatcher/query_dispatcher.cc
    db/scheduler_interface.cc

    GLOBAL oauth/oauth_impl.cc
    GLOBAL oauth/hack/oauth_impl.cc

    processor/handlers/abook_sync.cc
    processor/handlers/validate.cc
    processor/rfc822date.c
    GLOBAL processor/rpop/impl.cc
    processor/rpop/impl_headers.cc
    processor/rpop/impl_init.cc
    processor/rpop/impl_load.cc
    processor/rpop/impl_send.cc
    processor/triggers/abook.cc
    processor/triggers/email_validator.cc

    processor_ng/processor_header_generator.cc
    processor_ng/processor_header_handler.cc
    GLOBAL processor_ng/processor_service.cc

    GLOBAL smtp/module.cc

    scheduler/database.cc
    GLOBAL scheduler/impl.cc
    scheduler/limit.cc
    scheduler/plan_queue.cc
)

END()
