#!/usr/bin/env python3
import re
import os
import requests
import subprocess
import xml.etree.ElementTree as ET


def get_sharpei_url(config="/etc/collectors/config.yml"):
    cwd = os.getcwd()
    # иначе config-dumper не может распарсить первую строку конфиг файла в которой etc/collectors/base.yml
    os.chdir("/")
    process = subprocess.Popen(
        ["/usr/bin/config-dumper", config],
        stdout=subprocess.PIPE,
        bufsize=1,
        universal_newlines=True,
    )
    try:
        stdout, stderr = process.communicate(timeout=5)
    except:
        process.kill()
        process.wait()
        raise
    config_dump = stdout.split("\n")
    config = ET.fromstringlist(config_dump)
    sharpei_host = config.find("modules//configuration/sharpei/host")
    sharpei_port = config.find("modules//configuration/sharpei/port")
    os.chdir(cwd)

    return (
        "{}:{}".format(sharpei_host.text, sharpei_port.text) if sharpei_host is not None else None
    )


def get_acquired_db_list(hosts):
    acquired_dbs = dict()
    for host in hosts:
        url = "http://{}:8080/acquired_shards".format(host)
        try:
            r = requests.get(url, timeout=3)
            for shard in r.json():
                acquired_dbs[shard.get("id")] = host
        except:
            print("can not get data from host: {}".format(host))
    return acquired_dbs


def get_hosts():
    hosts = []
    for component in ["collectors", "canary"]:
        r = requests.get(
            "http://localhost:1/metadata?component={}&state=current&format=fqdn".format(component)
        )
        r.raise_for_status()
        hosts.extend(r.text.strip().split(","))
    return hosts
