#!/usr/bin/python
# -*- coding: utf-8 -*-

import psycopg2
import psycopg2.extras
import urllib2
import json
import os

if os.environ["QLOUD_ENVIRONMENT"] == "testing":
    SHARPEI_URL = "http://sharpei-testing.mail.yandex.net:80/v3/stat"
else:
    SHARPEI_URL = "http://sharpei.mail.yandex.net:80/v3/stat"
ACQUIRED_SHARDS_URL = "http://localhost:8080/acquired_shards"
FILENAME = "/var/collectors/all_uids.txt"


def load_url(url, add_headers={}, post_data=None):
    request = urllib2.Request(url, headers=add_headers, data=post_data)
    resp = urllib2.urlopen(request)
    return resp.read()


def get_acquired_shards():
    return json.loads(load_url(ACQUIRED_SHARDS_URL))


def get_sharpei_stat():
    return json.loads(load_url(SHARPEI_URL))


sharpei_stat = get_sharpei_stat()
uids = list()
current_shards = []
try:
    current_shards = get_acquired_shards()
except:
    pass
for shard in current_shards:
    shard_id = shard["id"]
    shard_info = sharpei_stat[shard_id]
    conninfo = None
    for db in shard_info["databases"]:
        if db["status"] == "alive":
            conninfo = "host={host} port={port} user=imap dbname={dbname} sslmode=require".format(
                host=db["address"]["host"],
                port=db["address"]["port"],
                dbname=db["address"]["dbname"],
            )
            break
    if conninfo:
        conn = psycopg2.connect(conninfo)
        cursor = conn.cursor(cursor_factory=psycopg2.extras.DictCursor)
        cursor.execute(
            "SELECT DISTINCT c.uid FROM mail.collectors c JOIN mail.users u ON c.uid=u.uid WHERE u.is_here=true AND u.is_deleted=false;"
        )
        uids += cursor.fetchall()


with open(FILENAME, "w") as uids_file:
    for uid in uids:
        uids_file.write(str(uid[0]) + "\n")
