#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

ts=$(date +%s)
prefix="collectors."

function run()
{
    timetail -n 60 -t imap $1 | head -n -1 | tr '[:upper:]' '[:lower:]' | \
    awk -v prefix=$prefix -v ts=$ts '
        @include "/usr/share/yandex-mail-common/metrics-util.awk"

        /finishing iteration/ {
            for (i=1; i <= NF; i++) {
                if ($i ~ /^streamer_state=/) {
                    state = substr($i, length("streamer_state=")+1)
                    gsub("(_|,| |-)", "", status)
                }
                if ($i ~ /^error_status=/) {
                    error = substr($i, length("error_status=")+1)
                    gsub("(_|,| |-)", "", error)
                }
            }

            finished["errors."error]++
            finished["states."state]++
        }
        END {
            for (metric in finished) {
                print prefix "finished." metric, finished[metric], ts
            }
        }'
}

run /var/log/collectors/collectors.log
