#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

ts=$(date +%s)
prefix="profiler."

function run()
{
    pa -t 60 $1 | tr '[:upper:]' '[:lower:]' | awk -v prefix=$prefix -v ts=$ts '
        @include "/usr/share/yandex-mail-common/metrics-util.awk"

        {
            type = $2
            if (type == "passport") {
                request = $(NF-1)
            } else {
                request = $4
            }
            tm = $NF
            key = type "." request

            metrics[key ".count"]++
            collect_timings(tm, key, metrics_tm)
        }
        END {
            for (key in metrics) {
                print prefix key, metrics[key], ts
            }
            for (metric in metrics_tm) {
                print prefix metric ".timings", "[" metrics_tm[metric] "]", ts
            }
        }'
}

run /var/log/collectors/profiler.log
