#!/usr/bin/python
# -*- coding: utf-8 -*-

import urllib2
import json
import os
import time

if os.environ["QLOUD_ENVIRONMENT"] == "testing":
    SHARPEI_URL = "http://sharpei-testing.mail.yandex.net:80/v3/stat"
else:
    SHARPEI_URL = "http://sharpei.mail.yandex.net:80/v3/stat"
ACQUIRED_SHARDS_URL = "http://localhost:8080/acquired_shards"


def load_url(url, add_headers={}, post_data=None):
    request = urllib2.Request(url, headers=add_headers, data=post_data)
    resp = urllib2.urlopen(request)
    return resp.read()


def get_acquired_shards():
    try:
        return list(json.loads(load_url(ACQUIRED_SHARDS_URL)))
    except:
        return list()


def get_sharpei_stat():
    try:
        return dict(json.loads(load_url(SHARPEI_URL)))
    except:
        return dict()


all_shards = [int(id) for id in get_sharpei_stat().keys()]
current_shards = list()
for shard in get_acquired_shards():
    current_shards.append(int(shard["id"]))

timestamp = int(time.time())

print "shards.known.sum_max {} {}".format(sum(all_shards), timestamp)
print "shards.current.sum {} {}".format(sum(current_shards), timestamp)
