#!/usr/bin/python
# -*- coding: utf-8 -*-

import urllib2
import json


LOADED_USERS_URL = "http://localhost:8080/loaded_users"
FILENAME = "/var/collectors/all_uids.txt"
USERS_THRESHOLD = 100


def load_url(url, add_headers={}, post_data=None):
    request = urllib2.Request(url, headers=add_headers, data=post_data)
    resp = urllib2.urlopen(request)
    return resp.read()


def get_loaded_users():
    try:
        return set(json.loads(load_url(LOADED_USERS_URL)))
    except:
        return set()


def get_target_users():
    try:
        with open(FILENAME, "r") as f:
            content = f.readlines()
            return set([x.strip() for x in content])
    except:
        return set()


def print_result(check_name, uids):
    if len(uids) > USERS_THRESHOLD:
        result = "2; %s: %s" % (len(uids), uids)
    elif uids:
        result = "1; %s: %s" % (len(uids), uids)
    else:
        result = "0; OK"

    print "PASSIVE-CHECK:" + check_name + ";" + result[:200]


loaded_uids = get_loaded_users()
target_uids = get_target_users()

missing_uids = target_uids - loaded_uids
print_result("missing_users", list(missing_uids))

additional_uids = loaded_uids - target_uids
print_result("additional_users", list(additional_uids))
