#! /bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

# TODO merge functions
function ephemeral_log {
    rm -rf "/var/log/$1"
    mkdir -p "/ephemeral/logs/$1"
    ln -s "/ephemeral/logs/$1" /var/log/
}
function ephemeral_var {
    rm -rf "/var/$1"
    mkdir -p "/ephemeral/$1"
    ln -s "/ephemeral/$1" /var/
}

app=$QLOUD_ENVIRONMENT
environment=$QLOUD_ENVIRONMENT
user=$QLOUD_EXEC_USER

[[ $app && $environment && $user ]] \
    || { echo "check env variables" > /errlog ; exit 1; }

# Make sure /ephemeral hase correct permissions first.
chmod 775 /ephemeral

ephemeral_log $app
mkdir -p /tmp/$app/ || true
ls /var/$app/* &>/dev/null && rm -rf /tmp/$app/* && mv /var/$app/* /tmp/$app/
ephemeral_var $app
ls /tmp/$app/* &>/dev/null && mv /tmp/$app/* /var/$app/

if ! id -u $user &>/dev/null; then
    adduser --system --disabled-password --group $user
    service procps restart
fi

# /etc
chown -R -H $user:$user /etc/$app
chmod 644 /etc/cron.d/*
chmod 644 /etc/logrotate.d/*
chmod 744 /etc/cron.yandex/*
chmod 440 /etc/sudoers.d/*

# /home
chown -R -H $user:$user /home/$user
[[ -f /home/$user/.pgpass ]] && chmod 600 /home/$user/.pgpass
[[ -f /home/$user/.postgresql/root.crt ]] && chmod 644 /home/$user/.postgresql/root.crt

# /var
chown -R -H $user:$user /var/$app
chown -R -H $user:$user /var/log/$app
chmod 755 /var/$app/
chmod 777 /var/log/
chmod 755 /var/log/$app/

uidmigrator=$(id -u $user)

TOTAL_PROCESSES_COUNT=10
for ((i=0;i<$TOTAL_PROCESSES_COUNT;i++));
do
    portoctl run "self/sub_main_$i" \
        respawn=true \
        isolate=false \
        command="/usr/sbin/migrator.py $TOTAL_PROCESSES_COUNT $i" \
        cwd='/' \
        user=$uidmigrator \
        stdout_path="/var/log/$app/stdout_$i" \
        stderr_path="/var/log/$app/stderr_$i"
done

exec /bin/sleep infinity
