#include "errors.h"

namespace collectors {

struct error_category : public boost::system::error_category
{
    const char* name() const noexcept override
    {
        return "collectors::error_category";
    }

    std::string message(int v) const override
    {
        return error_message(static_cast<code>(v));
    }
};

struct error_condition_category : public boost::system::error_category
{
    const char* name() const noexcept override
    {
        return "collectors::error_condition_category";
    }

    std::string message(int v) const override
    {
        return errc_message(static_cast<errc>(v));
    }

    bool equivalent(const boost::system::error_code& code, int condition) const noexcept override
    {
        errc e = static_cast<errc>(condition);
        switch (e)
        {
        case errc::ok:
            return !code;

        case errc::task_expired:
            return code == error(code::deleted_collector);

        default:
            return boost::system::error_category::equivalent(code, condition);
        }
    }

    bool equivalent(int code, const boost::system::error_condition& condition) const
        noexcept override
    {
        return boost::system::error_category::equivalent(code, condition);
    }
};

const boost::system::error_category& get_error_category()
{
    static struct error_category instance;
    return instance;
}

const boost::system::error_category& get_error_condition_category()
{
    static error_condition_category instance;
    return instance;
}

}
