#pragma once

#include "types.h"

#include <msgpack.hpp>

#include <functional>
#include <memory>
#include <string>
#include <vector>

namespace collectors {

struct folder
{
    fid parent_fid; // XXX key field?
    fid fid;
    std::string name;
    std::string symbol;

    bool skip_messages = false;

    MSGPACK_DEFINE(parent_fid, fid, name, symbol, skip_messages);
};

using folders = std::vector<folder>;
using folder_cb = std::function<void(error, const folder&)>;
using folders_cb = std::function<void(error, const folders&)>; // XXX actually propagated from
                                                               // mailbox.h -> declare in mailbox?

}
