#pragma once

#include "types.h"

#include <msgpack.hpp>

#include <functional>
#include <memory>
#include <string>
#include <vector>

namespace collectors {

struct label
{
    lid lid;
    std::string color;
    std::string symbol;
    std::string name;
    std::string type;

    MSGPACK_DEFINE(lid, color, symbol, name, type);
};

using labels = std::vector<label>;
using label_cb = std::function<void(error, const label&)>;
using labels_cb = std::function<void(error, const labels&)>;

}
