#pragma once

#include "label.h"
#include "types.h"

#include <ctime>
#include <functional>
#include <memory>
#include <string>
#include <vector>

#include <msgpack.hpp>

namespace collectors {

struct message
{
    mid mid;
    fid fid;
    stid stid; // XXX comment?
    std::time_t date;
    labels labels;
    std::string hdr_message_id;

    MSGPACK_DEFINE(mid, fid, stid, date, labels, hdr_message_id);
};

using messages = std::vector<message>;
using messages_ptr = std::shared_ptr<messages>;
using messages_cb = std::function<void(error, const messages&)>;

}
