#pragma once

#include "folder.h"
#include "label.h"
#include "message.h"

namespace collectors::msgpack {

template <typename T>
inline std::string pack(const T& message)
{
    ::msgpack::sbuffer sbuf;
    ::msgpack::pack(sbuf, message);
    return std::string(sbuf.data(), sbuf.data() + sbuf.size());
}

template <typename T>
T unpack(const std::string& source) noexcept
{
    T res;
    auto object = ::msgpack::unpack(source.data(), source.size());
    object.get().convert(res);
    return res;
}

}
