#include "types.h"

#include <yplatform/encoding/base64.h>
#include <yplatform/util/split.h>

namespace collectors {

global_collector_id::global_collector_id(
    const collectors::uid& uid,
    const collectors::collector_id& collector_id)
    : uid(uid), collector_id(collector_id)
{
}

global_collector_id::global_collector_id(const std::string& str)
{
    auto decoded = yplatform::base64_urlsafe_decode(str);
    auto decoded_str = std::string(decoded.begin(), decoded.end());
    auto data = yplatform::util::split(decoded_str, ":");
    if (data.size() != 2)
    {
        throw std::runtime_error("bad global_collector_id: " + str);
    }

    uid = data[0];
    collector_id = std::stoi(data[1]);
}

std::string global_collector_id::to_string() const
{
    if (uid.empty() || !collector_id) return "";

    std::string res = uid + ":" + std::to_string(collector_id);
    auto encoded = yplatform::base64_urlsafe_encode(res.begin(), res.end());
    return std::string(encoded.begin(), encoded.end());
}

bool global_collector_id::operator<(const global_collector_id& s) const
{
    return std::tie(uid, collector_id) < std::tie(s.uid, s.collector_id);
}

std::string collector_logging_info::to_string() const
{
    std::stringstream ss;
    ss << "dst_uid=" << dst_uid << " src_uid=" << src_uid << " id=" << id.to_string();
    return ss.str();
}

}
