#pragma once

#include <common/folder.h>
#include <common/label.h>
#include <common/message.h>

#include <macs/envelope.h>
#include <macs/folder.h>
#include <macs/label.h>
#include <macs/label_set.h>

#include <boost/algorithm/string.hpp>

namespace collectors::mailbox {

static const macs::Folder::SymbolSet& symbols_to_erase()
{
    static const macs::Folder::SymbolSet symbols = {
        macs::Folder::Symbol::archive,
        macs::Folder::Symbol::template_,
    };
    return symbols;
}

// XXX to ctors (in .cc)?
inline folder to_folder(const macs::Folder& macs_folder)
{
    std::vector<std::string> name_parts;
    boost::split(name_parts, macs_folder.name(), boost::is_any_of("|"));

    folder res;
    res.fid = macs_folder.fid();
    res.parent_fid = normalize_id(macs_folder.parentId());
    res.name = *std::prev(name_parts.end());
    if (!symbols_to_erase().count(macs_folder.symbolicName()))
    {
        res.symbol = macs_folder.symbolicName().title();
    }
    return res;
}

inline label to_label(const macs::Label& macs_label)
{
    label res;
    res.lid = macs_label.lid();
    res.color = macs_label.color();
    res.name = macs_label.name();
    res.symbol = macs_label.symbolicName().title();
    res.type = macs_label.type().title();
    return res;
}

inline message to_message(const macs::Envelope& envelope, const macs::LabelSet& macs_labels)
{
    message res;
    res.mid = envelope.mid();
    res.fid = envelope.fid();
    res.stid = envelope.stid();
    res.date = envelope.date();
    for (auto& lid : envelope.labels())
    {
        res.labels.push_back(to_label(macs_labels.at(lid)));
    }
    res.hdr_message_id = envelope.rfcId();
    return res;
}

}
