#pragma once

#include "settings.h"

#include <common/folder.h>
#include <common/label.h>
#include <common/message.h>
#include <common/types.h>

#include <memory>

namespace collectors::mailbox {

struct read_only_mailbox
{
    virtual ~read_only_mailbox(){};

    virtual void get_folders(const folders_cb& cb) = 0;
    virtual void get_labels(const labels_cb& cb) = 0;
    virtual void get_next_message_chunk(const mid& mid, uint64_t count, const messages_cb& cb) = 0;
};

struct mailbox : read_only_mailbox
{
    virtual ~mailbox(){};

    // XXX by fid/lid?
    virtual void get_folder_by_type(const std::string& title, const folder_cb& cb) = 0;
    virtual void create_folder(const folder& folder, const folder_cb& cb) = 0;
    virtual void create_label(const label& label, const label_cb& cb) = 0;
    virtual void store_message(
        const message& msg, // XXX forgotten move in callers -> && or const&;
        const std::string& email,
        bool disable_push,
        bool skip_loop_prevention,
        const std::vector<std::string>& rpop_ids,
        const std::string& rpop_info,
        const mid_cb& cb) = 0;
};

using read_only_mailbox_ptr = std::shared_ptr<read_only_mailbox>;
using mailbox_ptr = std::shared_ptr<mailbox>;
using ro_mailbox_cb = std::function<void(error, read_only_mailbox_ptr)>;

mailbox_ptr make_mailbox(context_ptr ctx, const uid& uid);
void make_read_only_mailbox(
    context_ptr ctx,
    const uid& uid,
    settings_ptr settings,
    const ro_mailbox_cb& cb);
void make_read_only_pop3_mailbox(
    context_ptr ctx,
    const uid& uid,
    settings_ptr settings,
    const ro_mailbox_cb& cb);
void make_local_read_only_mailbox(
    context_ptr ctx,
    const uid& uid,
    settings_ptr settings,
    const ro_mailbox_cb& cb);
void make_local_read_only_pop3_mailbox(
    context_ptr ctx,
    const uid& uid,
    settings_ptr settings,
    const ro_mailbox_cb& cb);

}
