#pragma once

#include <common/user_info.h>

#include <common/types.h>
#include <ymod_blackbox/address.h>

#include <memory>

// XXX passport->bb ?
namespace collectors::passport {

using address = ymod_blackbox::address;
using suid = std::string;
using suid_cb = std::function<void(error, const suid&)>;

// XXX why virtual ifaces not templates?
struct client
{
    virtual ~client()
    {
    }

    virtual void get_userinfo_by_suid(const std::string& suid, const user_info_cb& cb) = 0;
    virtual void get_userinfo_by_uid(const std::string& uid, const user_info_cb& cb) = 0;
    virtual void get_userinfo_by_login(const std::string& login, const user_info_cb& cb) = 0;
    virtual void check_auth_token(
        const std::string& token,
        address user_addr,
        const user_info_cb& cb) = 0;

    virtual void add_alias(
        const uid& uid,
        const std::string& alias,
        const std::string& consumer,
        const no_data_cb& cb) = 0;
    virtual void remove_alias(
        const uid& uid,
        const std::string& alias,
        const std::string& consumer,
        const no_data_cb& cb) = 0;

    virtual void get_suid(const uid& uid, const suid_cb& cb) = 0;
};

using client_ptr = std::shared_ptr<client>;

client_ptr make_passport_client(context_ptr ctx);

}
