#pragma once

#include "operation.h"

#include <yplatform/yield.h>

namespace collectors::streamer::operations {

struct get_or_create_folder_op : operation<folder_cb>
{
    using yield_ctx = yplatform::yield_context<get_or_create_folder_op>;
    using operation::operation;

    void operator()(yield_ctx ctx)
    {
        reenter(ctx)
        {
            if (state()->cached_folders.empty())
            {
                yield dst_mailbox()->get_folders(ctx.capture(ec, folders));
                if (ec) yield break;

                state()->cached_folders.insert(folders.begin(), folders.end());
            }

            folder.parent_fid = state()->folders_mapping[folder.parent_fid];
            {
                auto it = state()->cached_folders.find(folder);
                if (it != state()->cached_folders.end())
                {
                    res = *it;
                }
            }
            if (!res)
            {
                yield dst_mailbox()->create_folder(folder, ctx.capture(ec, folder));
                if (ec)
                {
                    state()->clear_folders();
                    yield break;
                }
                else
                {
                    res = folder;
                }

                state()->cached_folders.insert(*res);
            }
        }
        if (ctx.is_complete()) complete();
    }

    void operator()(yield_ctx ctx, const folder& folder)
    {
        this->folder = folder;
        (*this)(ctx);
    }

    void operator()(yield_ctx::exception_type exception)
    {
        ec = make_error(exception);
        TASK_LOG(context(), error)
            << "exception during get_or_create_folder_op: " << error_message(ec);
        complete();
    }

    void complete()
    {
        handler(ec, res ? *res : folder);
    }

    std::optional<folder> res;
    folder folder;
    folders folders;
    error ec;
};

}
