#pragma once

#include "operation.h"
#include "update_root_folder_with_inbox_op.h"

#include <yplatform/yield.h>

namespace collectors::streamer::operations {

struct map_folders_ignoring_folder_struct_op : operation<no_data_cb>
{
    using yield_ctx = yplatform::yield_context<map_folders_ignoring_folder_struct_op>;
    using operation::operation;

    void operator()(yield_ctx ctx)
    {
        reenter(ctx)
        {
            dst_fid = meta()->root_folder_id();
            if (is_empty_id(dst_fid))
            {
                yield spawn<update_root_folder_with_inbox_op>(ctx.capture(ec, dst_fid));
                if (ec) yield break;
            }

            yield src_mailbox()->get_folders(ctx.capture(ec, src_folders));
            if (ec) yield break;

            state()->clear_folders();
            for (auto& folder : src_folders)
            {
                state()->cached_src_folders[folder.fid] = folder;
                state()->folders_mapping[folder.fid] = dst_fid;
            }
        }
        if (ctx.is_complete()) complete();
    }

    void operator()(yield_ctx::exception_type exception)
    {
        ec = make_error(exception);
        TASK_LOG(context(), error)
            << "exception during map_folders_ignoring_folder_struct_op: " << error_message(ec);
        complete();
    }

    void complete()
    {
        handler(ec);
    }

    fid dst_fid;
    folders src_folders;
    error ec;
};

}
