#pragma once

#include "operation.h"

#include <yplatform/yield.h>

namespace collectors::streamer::operations {

struct sync_labels_op : operation<>
{
    using yield_ctx = yplatform::yield_context<sync_labels_op>;
    using operation::operation;

    void operator()(yield_ctx ctx)
    {
        reenter(ctx)
        {
            state()->labels_mapping.clear();

            if (state()->cached_labels.empty())
            {
                yield dst_mailbox()->get_labels(ctx.capture(ec, labels));
                if (ec) yield break;

                state()->cached_labels.insert(labels.begin(), labels.end());
            }

            while (src_labels.size())
            {
                current = src_labels.back();
                cached_label.reset();
                if (settings()->is_label_syncable(current) &&
                    !state()->labels_mapping.count(current.lid))
                {
                    {
                        auto it = state()->cached_labels.find(current);
                        if (it != state()->cached_labels.end())
                        {
                            cached_label = *it;
                        }
                    }
                    if (!cached_label)
                    {
                        TASK_LOG(context(), info)
                            << "creating label: " << current.name << "(" << current.type << ")";
                        yield dst_mailbox()->create_label(current, ctx.capture(ec, label));
                        if (ec)
                        {
                            state()->clear_labels();
                            yield break;
                        }
                        else
                        {
                            cached_label = label;
                        }

                        state()->cached_labels.insert(*cached_label);
                    }
                    state()->labels_mapping[current.lid] = cached_label->lid;
                }
                src_labels.pop_back();
            }
        }
        if (ctx.is_complete()) complete();
    }

    void operator()(yield_ctx ctx, const labels& labels)
    {
        src_labels = labels;
        ec = code::ok;
        (*this)(ctx);
    }

    void operator()(yield_ctx::exception_type exception)
    {
        ec = make_error(exception);
        TASK_LOG(context(), error) << "exception during sync_labels_op: " << error_message(ec);
        complete();
    }

    void complete()
    {
        handler(ec);
    }

    labels src_labels;
    label current;

    std::optional<label> cached_label;
    labels labels;
    label label;
    error ec;
};

}

#include <yplatform/unyield.h>
