#pragma once

#include "operation.h"

#include <yplatform/yield.h>

namespace collectors::streamer::operations {

struct update_root_folder_with_inbox_op : operation<fid_cb>
{
    using yield_ctx = yplatform::yield_context<update_root_folder_with_inbox_op>;
    using operation::operation;

    void operator()(yield_ctx ctx)
    {
        reenter(ctx)
        {
            yield dst_mailbox()->get_folder_by_type("inbox", ctx.capture(ec, folder));
            if (ec) yield break;

            inbox_fid = folder.fid;
            yield meta()->edit({}, inbox_fid, {}, ctx.capture(ec));
            if (ec)
            {
                TASK_LOG(context(), error) << "can't update root folder id: " << ec.message();
                // Ignore error, because it's not significant for sync
                ec = {};
            }
        }
        if (ctx.is_complete()) complete();
    }

    void operator()(yield_ctx::exception_type exception)
    {
        ec = make_error(exception);
        TASK_LOG(context(), error)
            << "exception during update_root_folder_with_inbox_op: " << error_message(ec);
        complete();
    }

    void complete()
    {
        handler(ec, inbox_fid);
    }

    fid inbox_fid;
    folder folder;
    error ec;
};

}
