#pragma once

#include <common/types.h>
#include <common/label.h>
#include <mailbox/settings.h>

namespace collectors::streamer {

// XXX define parsing func somewhere here (not module's responisiblity)
struct planner_settings
{
    time_traits::duration task_timeout;
    time_traits::duration task_penalty;
    std::uint32_t max_concurrency; // XXX no default
};

using planner_settings_ptr = std::shared_ptr<planner_settings>;

struct streamer_settings
{
    std::uint32_t collectors_load_chunk_size = 0;
    std::uint32_t message_cache_size = 0;
    std::uint32_t message_chunk_size = 0;
    std::uint32_t retries_limit = 0;
    std::uint32_t skipped_mids_limit = 0;
    std::string passport_consumer;
    std::set<std::string> allowed_system_labels;
    std::set<std::string> allowed_label_types;
    std::string rpop_smtp_data_secret;

    mailbox::settings mailbox_settings;

    bool is_label_syncable(const label& label)
    {
        if (label.symbol.empty())
        {
            return allowed_label_types.count(label.type);
        }
        else
        {
            return allowed_system_labels.count(label.symbol);
        }
    }
};

using streamer_settings_ptr = std::shared_ptr<streamer_settings>;

}
