#pragma once

#include <yplatform/coroutine.h>
#include <yplatform/util/tuple_unpack.h>

#include <memory>

namespace collectors::web {

namespace detail {

/*
 * binded_spawn_op save args from constructor and on each call operator(Args&&... args)
 * spawn coroutine with ctor_args and args
 */
template <typename F, typename... CtorArgs>
struct binded_spawn_op
{
    binded_spawn_op(CtorArgs&&... ctor_args) : ctor_args(std::forward<CtorArgs>(ctor_args)...)
    {
    }

    template <typename... Args>
    void operator()(Args&&... args)
    {
        auto coro = yplatform::util::call_with_tuple_args(
            &std::make_shared<F, const std::decay_t<CtorArgs>&..., Args...>,
            ctor_args,
            std::forward<Args>(args)...);
        yplatform::spawn(coro);
    }

    const std::tuple<std::decay_t<CtorArgs>...> ctor_args;
};

}

template <typename F, typename... CtorArgs>
detail::binded_spawn_op<F, CtorArgs...> binded_spawn(CtorArgs&&... ctor_args)
{
    return detail::binded_spawn_op<F, CtorArgs...>(std::forward<CtorArgs>(ctor_args)...);
}

}
