#pragma once

#include "response.h"

#include <common/types.h>
#include <common/json.h>

#include <ymod_mdb_sharder/shards_distributor.h>

namespace collectors::web::internal {

void get_acquired_buckets_info(ymod_webserver::http::stream_ptr stream)
{
    auto shards_distributor =
        yplatform::find<ymod_mdb_sharder::shards_distributor>("shards_distributor");
    shards_distributor->get_acquired_buckets_info([stream](auto&& buckets) {
        json::value result = Json::arrayValue;
        for (auto& [name, shards] : buckets)
        {
            json::value bucket_info;
            bucket_info["bucket_id"] = name;
            bucket_info["shards"] = Json::arrayValue;
            for (auto& shard_id : shards)
            {
                json::value shard_info;
                shard_info["id"] = shard_id;
                bucket_info["shards"].append(shard_info);
            }
            result.append(bucket_info);
        }
        respond(stream, json::to_string(result));
    });
}

}
