#pragma once

#include "response.h"

#include <common/types.h>
#include <common/json.h>

#include <ymod_mdb_sharder/shards_distributor.h>

namespace collectors::web::internal {

void get_acquired_shards(ymod_webserver::http::stream_ptr stream)
{
    auto shards_distributor =
        yplatform::find<ymod_mdb_sharder::shards_distributor>("shards_distributor");
    shards_distributor->get_acquired_shards([stream](auto&& shards) {
        json::value result = Json::arrayValue;
        for (auto& shard_id : shards)
        {
            json::value shard_info;
            shard_info["id"] = shard_id;
            result.append(shard_info);
        }
        respond(stream, json::to_string(result));
    });
}

}
