#pragma once

#include "response.h"

#include <common/types.h>
#include <common/msgpack.h>
#include <mailbox/mailbox.h>
#include <web/settings.h>

#include <ymod_webserver/response.h>

namespace collectors::web::internal {

void get_folders_from_mailbox(
    ymod_webserver::http::stream_ptr stream,
    error ec,
    mailbox::read_only_mailbox_ptr mailbox)
{
    if (ec == code::user_released) return respond(stream, ec, ymod_webserver::codes::gone);
    if (ec) return respond(stream, ec);

    mailbox->get_folders([stream](error ec, const folders& folders) {
        if (ec) return respond(stream, ec);

        respond(stream, msgpack::pack(folders));
    });
}

void get_folders(
    settings_ptr settings,
    ymod_webserver::http::stream_ptr stream,
    const std::string& uid)
{
    mailbox::make_local_read_only_mailbox(
        stream->ctx(),
        uid,
        std::shared_ptr<mailbox::settings>(settings, &settings->mailbox_settings),
        [stream](auto&& ec, auto&& mailbox) { get_folders_from_mailbox(stream, ec, mailbox); });
}

void get_pop3_folders(
    settings_ptr settings,
    ymod_webserver::http::stream_ptr stream,
    const std::string& uid)
{
    mailbox::make_local_read_only_pop3_mailbox(
        stream->ctx(),
        uid,
        std::shared_ptr<mailbox::settings>(settings, &settings->mailbox_settings),
        [stream](auto&& ec, auto&& mailbox) { get_folders_from_mailbox(stream, ec, mailbox); });
}

}
