#pragma once

#include "response.h"

#include <common/types.h>
#include <common/msgpack.h>
#include <mailbox/mailbox.h>
#include <web/settings.h>

#include <ymod_webserver/response.h>

namespace collectors::web::internal {

void get_labels(
    settings_ptr settings,
    ymod_webserver::http::stream_ptr stream,
    const std::string& uid)
{
    mailbox::make_local_read_only_mailbox(
        stream->ctx(),
        uid,
        std::shared_ptr<mailbox::settings>(settings, &settings->mailbox_settings),
        [stream](error ec, mailbox::read_only_mailbox_ptr mailbox) {
            if (ec == code::user_released) return respond(stream, ec, ymod_webserver::codes::gone);
            if (ec) return respond(stream, ec);

            mailbox->get_labels([stream](error ec, const labels& labels) {
                if (ec) return respond(stream, ec);

                respond(stream, msgpack::pack(labels));
            });
        });
}

}
