#pragma once

#include "response.h"

#include <common/types.h>
#include <common/json.h>
#include <streamer/module.h>

namespace collectors::web::internal {

void get_loaded_users(ymod_webserver::http::stream_ptr stream)
{
    auto streamer = yplatform::find<streamer::module>("streamer");
    streamer->list_users(stream->ctx(), [stream](const error& ec, const uids& ids) {
        if (ec)
        {
            respond(stream, ec);
            return;
        }

        json::value result = Json::arrayValue;
        for (auto& id : ids)
        {
            result.append(id);
        }
        respond(stream, json::to_string(result));
    });
}

}
