#pragma once

#include "response.h"

#include <common/types.h>
#include <common/msgpack.h>
#include <mailbox/mailbox.h>
#include <web/settings.h>

#include <ymod_webserver/response.h>

namespace collectors::web::internal {

void get_next_message_chunk_from_mailbox(
    ymod_webserver::http::stream_ptr stream,
    error ec,
    mailbox::read_only_mailbox_ptr mailbox,
    const mid& mid,
    uint64_t count)
{
    if (ec == code::user_released) return respond(stream, ec, ymod_webserver::codes::gone);
    if (ec) return respond(stream, ec);

    mailbox->get_next_message_chunk(mid, count, [stream](error ec, const messages& messages) {
        if (ec) return respond(stream, ec);

        respond(stream, msgpack::pack(messages));
    });
}

void get_next_message_chunk(
    settings_ptr settings,
    ymod_webserver::http::stream_ptr stream,
    const std::string& uid,
    const mid& mid,
    uint64_t count)
{
    mailbox::make_local_read_only_mailbox(
        stream->ctx(),
        uid,
        std::shared_ptr<mailbox::settings>(settings, &settings->mailbox_settings),
        [stream, mid, count](auto&& ec, auto&& mailbox) {
            get_next_message_chunk_from_mailbox(stream, ec, mailbox, mid, count);
        });
}

void get_pop3_next_message_chunk(
    settings_ptr settings,
    ymod_webserver::http::stream_ptr stream,
    const std::string& uid,
    const mid& mid,
    uint64_t count)
{
    mailbox::make_local_read_only_pop3_mailbox(
        stream->ctx(),
        uid,
        std::shared_ptr<mailbox::settings>(settings, &settings->mailbox_settings),
        [stream, mid, count](auto&& ec, auto&& mailbox) {
            get_next_message_chunk_from_mailbox(stream, ec, mailbox, mid, count);
        });
}

}
