#pragma once

#include <common/msgpack.h>

#include <ymod_webserver/response.h>

namespace collectors::web::internal {

inline void respond(ymod_webserver::http::stream_ptr stream, const std::string& resp)
{
    stream->ctx()->custom_log_data["status"] = "ok";
    stream->result(ymod_webserver::codes::ok, resp);
}

inline void respond(
    ymod_webserver::http::stream_ptr stream,
    error ec,
    ymod_webserver::codes::code code = ymod_webserver::codes::internal_server_error)
{
    stream->ctx()->custom_log_data["status"] = "error";
    stream->ctx()->custom_log_data["error_reason"] = ec.message();
    stream->result(code, ec.message());
}

}
