#pragma once

#include "response.h"

#include <common/types.h>
#include <common/json.h>
#include <streamer/module.h>

namespace collectors::web::internal {

void unload_user(ymod_webserver::http::stream_ptr stream, const std::string& uid)
{
    auto streamer = yplatform::find<streamer::module>("streamer");
    streamer->unload_user(stream->ctx(), uid, [stream](const error& ec) {
        if (ec)
        {
            respond(stream, ec);
        }
        else
        {
            respond(stream, "ok");
        }
    });
}

}
