#pragma once

#include "response.h"

#include <common/types.h>
#include <streamer/module.h>

namespace collectors::web::internal {

void unmigrate_collector(
    ymod_webserver::http::stream_ptr stream,
    const std::string& /*suid*/,
    const std::string& /*uid*/,
    const std::string& popid)
{
    auto streamer = yplatform::find<streamer::module>("streamer");
    streamer->unmigrate_collector(stream->ctx(), popid, [stream](const error& ec) {
        if (ec)
        {
            respond(stream, ec);
        }
        else
        {
            respond(stream, "OK");
        }
    });
}

}
