#pragma once

#include <common/types.h>

namespace collectors::web::methods {

template <typename Method>
class proxy_if_old_op
{
public:
    proxy_if_old_op(const Method& method, settings_ptr settings)
        : method_(method), settings_(settings)
    {
    }

    template <typename... Args>
    void operator()(
        ymod_webserver::http::stream_ptr stream,
        const std::string& suid,
        const std::string& uid,
        const std::string& popid,
        Args&&... args)
    {
        if (is_old_popid(popid))
        {
            proxy_rpop_api_request(
                stream, settings_, [](error ec, ymod_webserver::http::stream_ptr stream) {
                    if (ec)
                    {
                        respond(stream, ec, "proxy_if_old error");
                    }
                });
        }
        else
        {
            method_(stream, suid, uid, popid, std::forward<Args>(args)...);
        }
    }

private:
    typename std::decay<Method>::type method_;
    settings_ptr settings_;
};

}
