#pragma once

#include <common/types.h>
#include <streamer/module.h>

#include <ymod_webserver/response.h>
#include <yplatform/find.h>

namespace collectors::web::methods {

void update_collector_state(
    ymod_webserver::http::stream_ptr stream,
    const std::string& /*suid*/,
    const std::string& /*uid*/,
    const std::string& popid,
    bool is_on)
{
    auto streamer = yplatform::find<streamer::module>("streamer");
    auto global_id = global_collector_id(popid);
    auto new_state = is_on ? collector_state::created : collector_state::disabled;
    streamer->update_collector_state(
        stream->ctx(), global_id, new_state, [global_id, new_state, stream](error ec) {
            typed::log_api(
                stream->ctx(), global_id, "update_collector_state", ec, to_string(new_state));
            respond(stream, ec, "update_collector_state error");
        });
}

}
