#pragma once

#include <common/types.h>
#include <mailbox/settings.h>

#include <memory>
#include <set>
#include <string>
#include <unordered_map>

namespace collectors::web {

struct settings
{
    std::set<std::string> proxy_response_headers;
    std::set<std::string> remove_request_headers;

    std::string oauth_client_id;
    std::string oauth_client_secret;

    std::string social_application;
    std::string social_consumer;
    mailbox::settings mailbox_settings;

    std::string tvm_module;
    bool protect_localhost = false;
    std::unordered_map<uint32_t, std::string> allowed_sources;

    int retries_count = 3;
    time_traits::duration retries_delay = time_traits::milliseconds(400);

    std::string deleted_email_placeholder = "DELETED";
};

using settings_ptr = std::shared_ptr<settings>;

}
