# Тест для новых сборщиков с яндексовых ящиков на яндексовые

## Стенд

2 компоненты в Qloud: собственно сами сборщики + сервер с моками для них.

https://platform.yandex-team.ru/projects/mail/collectors/loadtest

База в данный момент используется железная pgload03.

## Моки

Все моки умеют делать задержку на ответ. Моки smtpgate, mulcagate, validator, passport возвращать некоторый процент ошибок

 - sharpei - статика на файлах, возвращает один шард. При переключении мастера базы надо править ответ мока.
 - smtpgate - любой ответ с кодом 200 - успех.
 - mulcagate (storage) - возвращает файл с мусором из набора (100Кб, 1Мб, 2Мб)
 - паспорт - питон-скрипт, который умеет три варианта ответов:
    - вернуть "токен" для юзера
    - вернуть информацию по токену
    - вернуть информацию по юзеру

## Данные для теста

Выбран подход с полным моком паспорта, для его упрощения решили ввести схему, когда имя пользователя формируется как `new-collector-<uid>`, токен делается как base64-encoded email. Таким образом на любом походе в паспорт/blackbox в переданной информации есть все, что нужно для генерации подходящего ответа.

Есть пять групп пользователей, реально отличаются от всех только доноры, потому что у них в норме непустые ящики, остальные потенциально взаимозаменимы, но лучше использовать их по записанной схеме, чтобы не возникало конфликтов.

1) Доноры. Диапазон uid 10000001000001 - 10000001050000, налито по 50 писем, в норме сборщики для них не создаем.
2) Активные источники (с покладкой). Диапазон uid 10000001100001 - 10000001200000, на старте пустые, в процессе стрельбы в них доливаются письма копированием из доноров, какой донорм используется определяется в патроне.
3) Активные приемники (соответствуют активным источникам). Диапазон uid 10000002100001 - 10000002200000
4) Пустые источники (без покладки). Диапазон uid 10000001200001 - 10000001300000, на старте пустые и должны такими и оставаться.
5) Пустые приемники (соответствуют пустым источникам). Диапазон uid 10000002200001 - 10000002300000

Общее правило сейчас, что пользователь приемник соответствует по uid источнику + 1000000 и предполагается, что один пользователь участвует только в одном сборщике (хотя технических препятствий делать несколько сборщиков на ящик в тесте нет).
Для приемников настоящей покладки не происходит, т.к. smtpgate замокан, так что данные о том, как идет реальная покладка надо извлекать из логов сборщиков и моков.

### Создание дополнительных пользователей

Нового пользователя в базе можно создать дернув процедуру `code.register_user`, чтобы создать сразу большой набор можно использовать `generate_series`, которому передать границы диапазона. При этом надо следить, чтобы не пересечься по диапазону с кем-то другим, ошибок повторная попытка создания не вызовет.

Выглядит запрос как-то так:

```select code.register_user(uid,'RU','RU',false,info) from (select generate_series(10000002200000,10000002300000) as uid, ('ya collectors load empty','ya collectors load empty')::code.request_info as info) x;
```

## Запуск теста

Для теста написана пушка на Go на базе pandora, в которой по сути объединены две:

 - http пушка для запросов на создание сборщиков и проксируемых запросов в мок yarm
 - postgresql пушка, для "доливки" новых писем в ящики источников

Собранная пушка залита в нагрузочный неймспейс https://storage-int.mds.yandex.net/get-load-ammo/29344/12d3367fcf9b4af1b601dde5805ec73d

Джоба для запуска стрельбы: https://jenkins-load.yandex-team.ru/job/ya_collectors/

Перед стартом джоба готовит состояние базы и патроны для стрельбы.

### Подготовка данных

Подготовка нужна для патронов, состояния источников и сборщиков. Доноры налиты фиксированным набором и их предполагается не трогать.

Подготовка патронов делается `tools/prepare_ammo.py`, в нем зашиты диапазоны пользователей (см. выше) и он достает из переменных окружения число активных и пустых сборщиков и готовит список патронов для `list` (из всех) и патроны для покладки в активных источников). Донор для каждого активного источника выбираетс случайно из списка всех доноров.

// TODO
Подготовка данных в базе:
1) забираются фактические данные о сборщиках
2) отдельно для активных и пустых сборщиков определяется сколько надо удалить/создать для достижения целевого числа
3) создаются / удаляются нужные сборщики
4) для активных источников участвующих в тесте чистятся ящики

### Постпроцессинг

После стрельбы логи сборщиков на мишене перекладываются в каталог `/var/log/collectors/lp_<номе стрельбы>`.

//TODO
После стрельбы нужно останавливать работу сборщиков.

## Дебаг 

Собранную пушку можно запустить вне танка для отладки, для этого надо сгенерировать патроны и передать ей конфиг (то, что в танке пишется в `pandora: config_content`), пример можно посмотреть в `debug-configs`.

Запрос на создание сборщика:
`curl 'collectors.loadtest.collectors.mail.stable.qloud-d.yandex.net:3048/api/create?user=new-collector-10000002100001@yandex.ru&mdb=maildb-load&suid=10000002100001&login=new-collector-10000001100001&server=imap.yandex.ru&email=new-collector-10000001100001@yandex.ru&port=993&ssl=1&no_delete_msgs=1&sync_abook=0&mark_archive_read=1' -d 'password=1234'`

Запрос на листинг:
`curl collectors.loadtest.collectors.mail.stable.qloud-d.yandex.net:3048/api/list?json=1&mdb=pg&suid=10000002100001`
