from mail.devpack.lib.components.postgres import Postgres


class CollieDb(Postgres):
    NAME = 'collie_db'

    before_all_prefixes = [
        'resfs/file/mail/pg/colliedb/drop',
    ]
    after_all_prefixes = [
        'resfs/file/mail/pg/colliedb/code',
        'resfs/file/mail/pg/colliedb/grants',
    ]
    migration_prefixes = [
        'resfs/file/mail/pg/colliedb/migrations',
    ]
    snapshot_sql_files = [
        'resfs/file/mail/pg/colliedb/collie.sql',
    ]

    def __init__(self, env, _):
        users = ['collie']
        self.init_from_conf(env.get_config(), self.NAME, users,
                            self.before_all_prefixes + self.migration_prefixes + self.after_all_prefixes)


class CollieDbForDirectorySync(CollieDb):
    NAME = 'collie_db_for_directory_sync'


class CollieDbForSync(CollieDb):
    NAME = 'collie_db_for_sync'
