-- name: IsUserExists
SELECT true
  FROM contacts.users
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND is_here
   AND not is_deleted;

-- name: CreateContactsUser
SELECT code.create_contacts_user(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_x_request_id := :x_request_id::text
);

-- name: RestoreContacts
SELECT code.restore_contacts(
    i_user_id := :uid::bigint,
    i_user_type := 'passport_user'::contacts.user_type,
    i_revision := :revision::bigint,
    i_x_request_id := :x_request_id::text
);

-- name: GetChanges
SELECT revision, EXTRACT(EPOCH FROM change_date)::bigint AS change_date, type
  FROM contacts.change_log
 WHERE user_id = :uid::bigint
   AND user_type = 'passport_user'::contacts.user_type

-- name: GetContacts
SELECT c.contact_id, c.list_id, c.revision,
       (c.vcard || jsonb_build_object('emails', (
          SELECT array_agg((e.contact_id, e.email, e.type, e.label)::code.new_contacts_email)
            FROM contacts.emails e
           WHERE e.user_id = c.user_id
             AND e.user_type = c.user_type
             AND e.contact_id = c.contact_id
       )))::text as vcard,
       COALESCE((
          SELECT array_agg(tag_id)
            FROM contacts.contacts_tags t
           WHERE t.user_id = c.user_id
             AND t.user_type = c.user_type
             AND t.contact_id = c.contact_id
       ), '{}'::bigint[]) as tag_ids,
       c.uri,
       COALESCE((
          SELECT array_agg((e.email_id, e.email,
              (SELECT array_agg(tag_id) AS tag_ids
                 FROM contacts.emails_tags t
                WHERE t.user_id = c.user_id
                  AND t.user_type = c.user_type
                  AND t.email_id = e.email_id))::code.contacts_email_with_tags)
            FROM contacts.emails e
           WHERE e.user_id = c.user_id
             AND e.user_type = c.user_type
             AND e.contact_id = c.contact_id
       ), '{}'::code.contacts_email_with_tags[]) as emails
  FROM contacts.contacts c
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND (
     array_length(:contact_ids::bigint[], 1) is NULL
     OR contact_id = ANY(:contact_ids::bigint[])
   )
   AND (
     array_length(:list_ids::bigint[], 1) is NULL
     OR list_id = ANY(:list_ids::bigint[])
   )
 ORDER BY contacts.generate_full_name(c.vcard)
 LIMIT :limit::bigint
OFFSET :offset::bigint;

-- name: GetContactsWithEmails
WITH contact_ids_with_emails AS (
  SELECT DISTINCT contact_id
    FROM contacts.emails
   WHERE user_id = :uid::bigint
     AND user_type = :user_type::contacts.user_type
     AND (
       array_length(:contact_ids::bigint[], 1) is NULL
       OR contact_id = ANY(:contact_ids::bigint[])
     )
)
SELECT c.contact_id, c.list_id, c.revision,
       (c.vcard || jsonb_build_object('emails', (
          SELECT array_agg((e.contact_id, e.email, e.type, e.label)::code.new_contacts_email)
            FROM contacts.emails e
           WHERE e.user_id = c.user_id
             AND e.user_type = c.user_type
             AND e.contact_id = c.contact_id
       )))::text as vcard,
       COALESCE((
          SELECT array_agg(tag_id)
            FROM contacts.contacts_tags t
           WHERE t.user_id = c.user_id
             AND t.user_type = c.user_type
             AND t.contact_id = c.contact_id
       ), '{}'::bigint[]) as tag_ids,
       c.uri,
       COALESCE((
          SELECT array_agg((e.email_id, e.email,
              (SELECT array_agg(tag_id) AS tag_ids
                 FROM contacts.emails_tags t
                WHERE t.user_id = c.user_id
                  AND t.user_type = c.user_type
                  AND t.email_id = e.email_id))::code.contacts_email_with_tags)
            FROM contacts.emails e
           WHERE e.user_id = c.user_id
             AND e.user_type = c.user_type
             AND e.contact_id = c.contact_id
       ), '{}'::code.contacts_email_with_tags[]) as emails
  FROM contacts.contacts c
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND contact_id IN (
     SELECT contact_id
       FROM contact_ids_with_emails
   )
   AND (
     array_length(:list_ids::bigint[], 1) is NULL
     OR list_id = ANY(:list_ids::bigint[])
   )
 ORDER BY contacts.generate_full_name(c.vcard)
 LIMIT :limit::bigint
OFFSET :offset::bigint;

-- name: GetContactsByTagId
WITH contact_ids AS (
    SELECT contact_id
      FROM contacts.contacts_tags
     WHERE user_id = :uid::bigint
       AND user_type = 'passport_user'::contacts.user_type
       AND tag_id = :tag_id::bigint
)
SELECT c.contact_id, c.list_id, c.revision,
       (c.vcard || jsonb_build_object('emails', (
          SELECT array_agg((e.contact_id, e.email, e.type, e.label)::code.new_contacts_email)
            FROM contacts.emails e
           WHERE e.user_id = c.user_id
             AND e.user_type = c.user_type
             AND e.contact_id = c.contact_id
       )))::text as vcard,
       COALESCE((
          SELECT array_agg(tag_id)
            FROM contacts.contacts_tags t
           WHERE t.user_id = c.user_id
             AND t.user_type = c.user_type
             AND t.contact_id = c.contact_id
       ), '{}'::bigint[]) as tag_ids,
       c.uri,
       COALESCE((
          SELECT array_agg((e.email_id, e.email,
              (SELECT array_agg(tag_id) AS tag_ids
                 FROM contacts.emails_tags t
                WHERE t.user_id = c.user_id
                  AND t.user_type = c.user_type
                  AND t.email_id = e.email_id))::code.contacts_email_with_tags)
            FROM contacts.emails e
           WHERE e.user_id = c.user_id
             AND e.user_type = c.user_type
             AND e.contact_id = c.contact_id
       ), '{}'::code.contacts_email_with_tags[]) as emails
  FROM contacts.contacts c
 WHERE user_id = :uid::bigint
   AND user_type = 'passport_user'::contacts.user_type
   AND contact_id IN (
     SELECT contact_id
       FROM contact_ids
   )
 ORDER BY contacts.generate_full_name(c.vcard)
 LIMIT :limit::bigint
OFFSET :offset::bigint;

-- name: RemoveContacts
SELECT code.delete_contacts(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_contact_ids := :contact_ids::bigint[],
    i_x_request_id := :x_request_id::text
);

-- name: GetUserTypeLists
SELECT list_id, name
  FROM contacts.lists
 WHERE user_id = :uid::bigint
  AND user_type = 'passport_user'::contacts.user_type
  AND type = 'user'::contacts.list_type;

-- name: CreateTag
SELECT result.revision AS revision, result.tag_id AS tag_id FROM code.create_contacts_tag(
    i_user_id := :uid::bigint,
    i_user_type := 'passport_user'::contacts.user_type,
    i_name := :name::text,
    i_type := 'user'::contacts.tag_type,
    i_x_request_id := :x_request_id::text
) result;

-- name: GetTags
SELECT t.tag_id, t.type, t.name, t.revision,
       (SELECT count(1)
          FROM contacts.contacts_tags ct
         WHERE ct.user_id = t.user_id
           AND ct.user_type = t.user_type
           AND ct.tag_id = t.tag_id
       )::bigint as contacts_count
  FROM contacts.tags t
 WHERE user_id = :uid::bigint
   AND user_type = 'passport_user'::contacts.user_type;

-- name: RemoveTag
SELECT code.delete_contacts_tag(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_tag_id := :tag_id::bigint,
    i_x_request_id := :x_request_id::text
);

-- name: UpdateTag
SELECT code.update_contacts_tag(
    i_user_id := :uid::bigint,
    i_user_type := 'passport_user'::contacts.user_type,
    i_tag_id := :tag_id::bigint,
    i_name := :name::text,
    i_x_request_id := :x_request_id::text,
    i_revision := :revision::bigint
);

-- name: GetContactsCount
SELECT count(1)
  FROM contacts.contacts
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND (
     array_length(:list_ids::bigint[], 1) is NULL
     OR list_id = ANY(:list_ids::bigint[])
   );

-- name: GetContactsWithEmailsCount
WITH contact_ids_with_emails AS (
  SELECT DISTINCT contact_id
    FROM contacts.emails
   WHERE user_id = :uid::bigint
     AND user_type = :user_type::contacts.user_type
)
SELECT count(1)
  FROM contacts.contacts
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND contact_id IN (
     SELECT contact_id
       FROM contact_ids_with_emails
   )
   AND (
     array_length(:list_ids::bigint[], 1) is NULL
     OR list_id = ANY(:list_ids::bigint[])
   );

-- name: CreateContacts
SELECT code.create_contacts(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_contacts := :contacts::code.new_contact[],
    i_x_request_id := :x_request_id::text
);

-- name: CreateContactsEmails
SELECT code.create_contacts_emails(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_emails := :emails::code.new_contacts_email[],
    i_x_request_id := :x_request_id::text
);

-- name: TagContacts
SELECT code.tag_contacts(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_tag_id := :tag_id::bigint,
    i_contact_ids := :contact_ids::bigint[],
    i_x_request_id := :x_request_id::text
);

-- name: TagContactsEmails
SELECT code.tag_contacts_emails(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_tag_id := :tag_id::bigint,
    i_email_ids := :email_ids::bigint[],
    i_x_request_id := :x_request_id::text
);

-- name: AcquireRevision
SELECT code.acquire_contacts_revision(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type
);

-- name: UpdateContacts
SELECT code.update_contacts(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_contacts := :contacts::code.updated_contact[],
    i_x_request_id := :x_request_id::text,
    i_revision := :revision::bigint
);

-- name: GetContactsEmailIdsByContactsIds
SELECT contact_id, email_id, email
  FROM contacts.emails
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND contact_id = ANY(:contacts_ids::bigint[]);

-- name: GetContactsIdsByContactsEmailIds
SELECT contact_id, email_id
  FROM contacts.emails
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND email_id = ANY(:email_ids::bigint[]);

-- name: GetContactsEmailIdsByTagIds
SELECT email_id
  FROM contacts.emails_tags
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND tag_id = ANY(:tag_ids::bigint[]);

-- name: GetContactsEmailIdsByContactIdAndTagIds
SELECT email_id
  FROM contacts.emails_tags
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND contact_id = :contact_id::bigint
   AND tag_id = ANY(:tag_ids::bigint[]);

-- name: GetContactsEmailsByTagIds
SELECT et.tag_id, e.email_id, e.contact_id, e.revision, e.email, e.type, e.label
  FROM contacts.emails e
  JOIN contacts.emails_tags et
 USING (user_id, user_type, email_id)
 WHERE e.user_id = :uid::bigint
   AND e.user_type = :user_type::contacts.user_type
   AND et.tag_id = ANY(:tag_ids::bigint[]);

-- name: GetEmailIdsTagIdsByEmailIds
SELECT email_id, tag_id
  FROM contacts.emails_tags
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND email_id = ANY(:email_ids::bigint[]);

-- name: GetContactIdsByTagIds
SELECT contact_id
  FROM contacts.contacts_tags
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND tag_id = ANY(:tag_ids::bigint[]);

-- name: GetContactIdsTagIdsByContactIds
SELECT contact_id, tag_id
  FROM contacts.contacts_tags
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND contact_id = ANY(:contact_ids::bigint[]);

-- name: UpdateContactsEmails
SELECT code.update_contacts_emails(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_emails := :emails::code.updated_contacts_email[],
    i_x_request_id := :x_request_id::text,
    i_revision := :revision::bigint
);

-- name: RemoveContactsEmails
SELECT code.delete_contacts_emails(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_email_ids := :email_ids::bigint[],
    i_x_request_id := :x_request_id::text
);

-- name: UntagContacts
SELECT code.untag_contacts(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_tag_id := :tag_id::bigint,
    i_contact_ids := :contact_ids::bigint[],
    i_x_request_id := :x_request_id::text
);

-- name: UntagContactsCompletely
SELECT code.untag_contacts_completely(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_contact_ids := :contact_ids::bigint[],
    i_x_request_id := :x_request_id::text
);

-- name: UntagContactsEmails
SELECT code.untag_contacts_emails(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_tag_id := :tag_id::bigint,
    i_email_ids := :email_ids::bigint[],
    i_x_request_id := :x_request_id::text
);

-- name: UntagContactsEmailsCompletely
SELECT code.untag_contacts_emails_completely(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_email_ids := :email_ids::bigint[],
    i_x_request_id := :x_request_id::text
);

--name: GetDefaultListId
SELECT list_id
  FROM contacts.lists
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND type = 'personal'
   AND unique_type = true;

-- name: GetOnlyNewEmails
SELECT *
  FROM UNNEST(:emails::text[])
EXCEPT
    SELECT email
      FROM contacts.emails
     WHERE user_id = :uid::bigint
       AND user_type = :user_type::contacts.user_type;

-- name: GetContactsByTagNameAndTagTypeAndUris
WITH tags AS (
    SELECT contact_id
      FROM contacts.contacts_tags
      JOIN contacts.tags t
    USING(user_id, user_type, tag_id)
    WHERE t.user_id = :uid::bigint
      AND t.user_type = :user_type::contacts.user_type
      AND t.type = :tag_type::contacts.tag_type
      AND t.name = :tag_name::text
)
SELECT c.contact_id, c.revision,
       (c.vcard || jsonb_build_object('emails', (
          SELECT array_agg((e.contact_id, e.email, e.type, e.label)::code.new_contacts_email)
            FROM contacts.emails e
           WHERE e.user_id = c.user_id
             AND e.user_type = c.user_type
             AND e.contact_id = c.contact_id
       )))::text as vcard,
       c.uri
  FROM contacts.contacts c
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND contact_id IN (
     SELECT contact_id
       FROM tags
   )
   AND (
     array_length(:uris::text[], 1) is NULL
     OR COALESCE(uri, 'YA-' || contact_id::text) = ANY(:uris::text[])
   );

-- name: GetTagIdByTagNameAndTagType
SELECT tag_id
  FROM contacts.tags
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND type = :tag_type::contacts.tag_type
   AND name = :tag_name::text;

-- name: GetSharedContacts
WITH shared_list_ids AS (
    SELECT list_id
      FROM contacts.shared_lists
    WHERE user_id = :uid::bigint
      AND user_type = :user_type::contacts.user_type
      AND client_user_id = :client_uid::bigint
      AND client_user_type = :client_user_type::contacts.user_type
      AND (
        array_length(:list_ids::bigint[], 1) is NULL
        OR list_id = ANY(:list_ids::bigint[])
      )
)
SELECT c.contact_id, c.list_id, c.revision,
       (c.vcard || jsonb_build_object('emails', (
          SELECT array_agg((e.contact_id, e.email, e.type, e.label)::code.new_contacts_email)
            FROM contacts.emails e
           WHERE e.user_id = c.user_id
             AND e.user_type = c.user_type
             AND e.contact_id = c.contact_id
       )))::text as vcard,
       COALESCE((
          SELECT array_agg(tag_id)
            FROM contacts.contacts_tags t
           WHERE t.user_id = c.user_id
             AND t.user_type = c.user_type
             AND t.contact_id = c.contact_id
       ), '{}'::bigint[]) as tag_ids,
       c.uri,
       COALESCE((
          SELECT array_agg((e.email_id, e.email,
              (SELECT array_agg(tag_id) AS tag_ids
                 FROM contacts.emails_tags t
                WHERE t.user_id = c.user_id
                  AND t.user_type = c.user_type
                  AND t.email_id = e.email_id))::code.contacts_email_with_tags)
            FROM contacts.emails e
           WHERE e.user_id = c.user_id
             AND e.user_type = c.user_type
             AND e.contact_id = c.contact_id
       ), '{}'::code.contacts_email_with_tags[]) as emails
  FROM contacts.contacts c
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND list_id IN (
     SELECT list_id
       FROM shared_list_ids
   )
 ORDER BY contacts.generate_full_name(c.vcard);

-- name: SubscribeToContactsList
SELECT code.subscribe_to_contacts_list(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_list_id := :list_id::bigint,
    i_owner_user_id := :owner_user_id::bigint,
    i_owner_user_type := :owner_user_type::contacts.user_type,
    i_owner_list_id := :owner_list_id::bigint,
    i_x_request_id := :x_request_id::text
);

-- name: RevokeSubscribedContactsList
SELECT code.revoke_subscribed_contacts_list(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_list_id := :list_id::bigint,
    i_owner_user_id := :owner_user_id::bigint,
    i_owner_user_type := :owner_user_type::contacts.user_type,
    i_owner_list_id := :owner_list_id::bigint,
    i_x_request_id := :x_request_id::text
);

-- name: ShareContactsList
SELECT code.share_contacts_list(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_list_id := :list_id::bigint,
    i_client_user_id := :client_user_id::bigint,
    i_client_user_type := :client_user_type::contacts.user_type,
    i_x_request_id := :x_request_id::text
);

-- name: RevokeContactsList
SELECT code.revoke_contacts_list(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_list_id := :list_id::bigint,
    i_client_user_id := :client_user_id::bigint,
    i_client_user_type := :client_user_type::contacts.user_type,
    i_x_request_id := :x_request_id::text
);

-- name: GetSubscribedList
SELECT list_id, owner_user_id, owner_user_type::text, owner_list_id
  FROM contacts.subscribed_lists
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND list_id = :list_id::bigint;

-- name: GetSubscribedLists
SELECT list_id, owner_user_id, owner_user_type::text, owner_list_id
  FROM contacts.subscribed_lists
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type;

-- name: GetDirectoryEntities
SELECT directory_entity_id AS id, directory_entity_type AS type, contact_id
  FROM contacts.directory_entities
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type;

-- name: CreateDirectoryEntities
SELECT code.create_contacts_directory_entities(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_directory_entities := :directory_entities::code.directory_entity[],
    i_x_request_id := :x_request_id::text
);

-- name: RemoveDirectoryEntities
SELECT code.delete_contacts_directory_entities(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_directory_entities := :directory_entities::code.directory_entity_id_and_type[],
    i_x_request_id := :x_request_id::text
);

-- name: GetSharedContactsCount
WITH shared_list_ids AS (
    SELECT list_id
      FROM contacts.shared_lists
    WHERE user_id = :uid::bigint
      AND user_type = :user_type::contacts.user_type
      AND client_user_id = :client_uid::bigint
      AND client_user_type = :client_user_type::contacts.user_type
      AND (
        array_length(:list_ids::bigint[], 1) is NULL
        OR list_id = ANY(:list_ids::bigint[])
      )
)
SELECT count(1)
  FROM contacts.contacts
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND list_id IN (
     SELECT list_id
       FROM shared_list_ids
   );

-- name: GetSharedContactsCountWithEmails
WITH shared_contacts_ids AS (
    SELECT contact_id
      FROM contacts.contacts
     WHERE user_id = :uid::bigint
       AND user_type = :user_type::contacts.user_type
       AND list_id IN (
        SELECT list_id
          FROM contacts.shared_lists
        WHERE user_id = :uid::bigint
          AND user_type = :user_type::contacts.user_type
          AND client_user_id = :client_uid::bigint
          AND client_user_type = :client_user_type::contacts.user_type
          AND (
            array_length(:list_ids::bigint[], 1) is NULL
            OR list_id = ANY(:list_ids::bigint[])
          )
       )
)
SELECT count(distinct contact_id)
  FROM contacts.emails
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND contact_id IN (
     SELECT contact_id
       FROM shared_contacts_ids
   );

-- name: GetSharedLists
SELECT list_id, client_user_id, client_user_type::text
  FROM contacts.shared_lists
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type;

-- name: CreateContactsList
SELECT result.revision AS revision, result.list_id AS list_id FROM code.create_contacts_list(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_name := :name::text,
    i_type := :type::contacts.list_type,
    i_x_request_id := :x_request_id::text
) result;

-- name: DeleteContactsList
SELECT code.delete_contacts_list(
    i_user_id := :uid::bigint,
    i_user_type := :user_type::contacts.user_type,
    i_list_id := :list_id::bigint,
    i_x_request_id := :x_request_id::text
);

-- name: GetSubscribedListIdsByOwner
SELECT list_id
  FROM contacts.subscribed_lists
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND owner_user_id = :owner_uid::bigint
   AND owner_user_type = :owner_user_type::contacts.user_type;

-- name: GetTagById
SELECT t.tag_id, t.type, t.name, t.revision,
       (SELECT count(1)
          FROM contacts.contacts_tags ct
         WHERE ct.user_id = t.user_id
           AND ct.user_type = t.user_type
           AND ct.tag_id = t.tag_id
       )::bigint as contacts_count
  FROM contacts.tags t
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND tag_id = :tag_id::bigint;

-- name: GetContactIdsByListIds
SELECT contact_id
  FROM contacts.contacts
 WHERE user_id = :uid::bigint
   AND user_type = :user_type::contacts.user_type
   AND list_id = ANY(:list_ids::bigint[])
EXCEPT
    SELECT *
      FROM UNNEST(:contact_ids::bigint[]);

-- name: PurgeContactsUser
SELECT code.purge_contacts_user(
  i_user_id := :uid::bigint,
  i_user_type := :user_type::contacts.user_type,
  i_force := :force::boolean,
  i_full := :full::boolean
);
