-- name: GetUserToSyncByEventsCount
SELECT user_id, synced_revision, synced_event_id, event_type
  FROM collie.directory_events
 WHERE user_type = 'connect_organization'::collie.user_type
   AND pending_events_count > 0
 ORDER BY pending_events_count DESC
 LIMIT 1
   FOR NO KEY UPDATE SKIP LOCKED;

-- name: GetUserToSyncByLastSyncDate
SELECT user_id, synced_revision, synced_event_id, event_type
  FROM collie.directory_events
 WHERE user_type = 'connect_organization'::collie.user_type
   AND EXTRACT(EPOCH FROM (now() - last_sync_date))::bigint >= (:sync_interval_in_minutes::bigint * 60)
 ORDER BY last_sync_date ASC
 LIMIT 1
   FOR NO KEY UPDATE SKIP LOCKED;

-- name: CompleteSyncDirectoryEvent
SELECT code.complete_sync_directory_event(
    i_user_id := :user_id,
    i_user_type := 'connect_organization'::collie.user_type,
    i_synced_revision := :synced_revision,
    i_synced_event_id := :synced_event_id
);

-- name: CompleteDirectoryOrganizationRemoval
SELECT code.complete_directory_organization_removal(
    i_user_id := :user_id,
    i_user_type := 'connect_organization'::collie.user_type
);

-- name: AddDirectoryEvents
SELECT code.add_directory_events(
    i_user_id := :user_id,
    i_user_type := 'connect_organization'::collie.user_type,
    i_event_count := :event_count,
    i_event_type := :event_type,
    i_event_revision := :event_revision
);

-- name: AddDirectoryEvent
SELECT code.add_directory_event(
    i_user_id := :user_id,
    i_user_type := 'connect_organization'::collie.user_type
);

-- name: AddDirectoryEventForUsers
SELECT code.add_directory_event(
    i_user_ids := :user_ids::bigint[],
    i_user_type := 'connect_organization'::collie.user_type
);

-- name: GetServiceSyncTimestamp
SELECT EXTRACT(EPOCH FROM sync_timestamp)::bigint AS sync_timestamp
  FROM collie.service_sync
 WHERE service_type = :service_type::collie.service_type
   FOR NO KEY UPDATE SKIP LOCKED;

-- name: SetServiceSyncTimestamp
SELECT code.set_service_sync_timestamp(
    i_service_type := :service_type::collie.service_type
);

-- name: AddStaffIdMapElements
SELECT code.add_staff_id_map_elements(
    i_elements := :elements::code.id_map_element[]
);

-- name: DeleteContactIdsByStaffIds
SELECT code.delete_contact_ids_by_staff_ids(
    i_ids := :ids::bigint[]
);

-- name: GetStaffIdMapElements
SELECT staff_id AS key_id, contact_id AS value_id
  FROM collie.staff_id_map;

-- name: AddMlIdMapElements
SELECT code.add_ml_id_map_elements(
    i_elements := :elements::code.id_map_element[]
);

-- name: DeleteContactIdsByMlIds
SELECT code.delete_contact_ids_by_ml_ids(
    i_ids := :ids::bigint[]
);

-- name: GetMlIdMapElements
SELECT ml_id AS key_id, contact_id AS value_id
  FROM collie.ml_id_map;
